IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Doc_Nro_UY_Validar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Doc_Nro_UY_Validar
END
GO

CREATE FUNCTION dbo.CF_Doc_Nro_UY_Validar(@pDoc_Nro BIGINT)
RETURNS BIGINT
AS
BEGIN
DECLARE @Doc_Nro_Validado		BIGINT
DECLARE @Doc_Nro_Validado_VC	VARCHAR(20)
DECLARE @Doc_Nro_VC				VARCHAR(20)
DECLARE @Suma					INT
DECLARE @Media					INT
DECLARE @Digito_Verificador		TINYINT

SET @Doc_Nro_VC = CONVERT(VARCHAR(20), @pDoc_Nro)

--Si el Doc_Nro no tiene al menos 7 u 8 digitos ya no se puede calcular
IF(LEN(@Doc_Nro_VC) NOT IN (7,8))
BEGIN	
	SET @Doc_Nro_Validado = 0
	RETURN @Doc_Nro_Validado
END

SET @Suma = (CONVERT(TINYINT, SUBSTRING(@Doc_Nro_VC, 1, 1)) * 2) +
			(CONVERT(TINYINT, SUBSTRING(@Doc_Nro_VC, 2, 1)) * 9) +
			(CONVERT(TINYINT, SUBSTRING(@Doc_Nro_VC, 3, 1)) * 8) +
			(CONVERT(TINYINT, SUBSTRING(@Doc_Nro_VC, 4, 1)) * 7) +
			(CONVERT(TINYINT, SUBSTRING(@Doc_Nro_VC, 5, 1)) * 6) + 
			(CONVERT(TINYINT, SUBSTRING(@Doc_Nro_VC, 6, 1)) * 3) +
			(CONVERT(TINYINT, SUBSTRING(@Doc_Nro_VC, 7, 1)) * 4)

SET @Media = (@Suma % 10)

SET @Digito_Verificador =  ((10 - @Media) % 10)

SET @Doc_Nro_Validado_VC = SUBSTRING(@Doc_Nro_VC, 1, 7) + CONVERT(VARCHAR(1), @Digito_Verificador)

SET @Doc_Nro_Validado = CONVERT(BIGINT, @Doc_Nro_Validado_VC)

RETURN ISNULL(@Doc_Nro_Validado, 0)
END

--SELECT dbo.CF_Doc_Nro_UY_Validar(19359017)